%%%%% trade finance static model%%%%

cepath='D:\MATLAB-2018\CompEcon\'; path([cepath 'cetools;' cepath 'cedemos'],path);

%% Parameters and Exogen Variables
mu_us = 0.2; 
mu_ez = 0.2;

% mu_Us_{t+1} = rho * mu_Us_{t+1} + epsilon_{t+1}
mu_rw = 1-mu_us-mu_ez;

bbar_us =  1.471;

bbar_ez_grid = (0.971:0.02:1.471)';

%pi= 0.01; 
n = size(bbar_ez_grid,1);

r = 0.005; 
%kappa= (pi-r)/(bbar_us+1); 
kappa = 0.01;

pi = 1;

kappa_sunspot1 = (pi-r)/(bbar_us+0.5*mu_rw+0.5);
kappa_sunspot2 = (pi-r)/(bbar_ez_grid+0.5*mu_rw+0.5);

% kappa < min(kappa_sunspot1,kappa_sunspot2);

X_rw_1 = zeros(n,1);
X_rw_2 = zeros(n,1);
X_rw_CP = zeros(n,1);

%% 
%bdollar_rw = bbar * (xrw/((mu_rw*xrw)+mu_us)); condition 8
%beuro_rw = bbar_ez * ((1-xrw)/((mu_rw*(1-xrw))+mu_ez)); condition 9
%xbar= mu_us + (mu_rw*xrw); average x 

%xrw = fsolve(@(xrw) dollarusage(xrw, mu_us, mu_ez, mu_rw, bbar, pi, r, kappa), 0.1)
%xrw = fsolve(@(xrw) dollarusage(xrw, mu_us, mu_ez, mu_rw, bbar_us, pi, r, kappa, bbar_ez), 0.2)

%bdollar_rw = bbar_us * (xrw/((mu_rw*xrw)+mu_us))
%beuro_rw = bbar_ez * ((1-xrw)/((mu_rw*(1-xrw))+mu_ez))
for i = 1:n

    bbar_ez = bbar_ez_grid(i);

    xrw_1 = fsolve(@(xrw) dusage_poly(xrw, mu_us, mu_ez, mu_rw, bbar_us, pi, r, kappa, bbar_ez), 0.1);

    X_rw_1(i) = xrw_1;
    
    % RMB Usage
    RMB_1(i) = 1-xrw_1;

    xrw_2 = fsolve(@(xrw) dollarusage(xrw, mu_us, mu_ez, mu_rw, bbar_us, pi, r, kappa, bbar_ez), 0.1);

    X_rw_2(i) = xrw_2;
    
    % RMB Usage
    RMB_2(i) = 1-xrw_2;

    %% CP

    func = @(xrw) dollarusage(xrw, mu_us, mu_ez, mu_rw, bbar_us, pi, r, kappa, bbar_ez);

    x0 = ones(1,1)/4;

    [~, ~] = func_CP(x0, func); 

    myfun = @(x) func_CP(x, func); 

    xlow  = zeros(1,1); % lower bound
    xhigh = ones(1,1); % upper bound

    xvalue = ncpsolve(myfun, xlow, xhigh, x0);

    dusage = func(xvalue)';

    X_rw_CP(i) = xvalue(1);
    
    RMB_CP(i) = 1-xvalue;


end

figure;
subplot(1,3,1)
plot(bbar_ez_grid,RMB_1,'b','LineWidth',1.5)
xlabel('Supply of RMB bonds')
ylabel('RMB usage in the world')   
title('Solver 1')

subplot(1,3,2)
plot(bbar_ez_grid,RMB_2,'k','LineWidth',1.5)
xlabel('Supply of RMB bonds')
ylabel('RMB usage in the world')   
title('Solver 2')

subplot(1,3,3)
plot(bbar_ez_grid,RMB_CP,'y','LineWidth',1.5)
xlabel('Supply of RMB bonds')
ylabel('RMB usage in the world')   
title('Solver CP')





